#include <stdio.h>		/* For printf */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    int     nchan;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[2];
    SHORTSIZ16 group;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);

#if 0
    CHECK(e1432_install(1, &laddr, 0, "/opt/e1432/lib/sema.bin"));
#endif

#if 0
    {
	struct e1432_hwconfig hwconfig;
	CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
	(void) printf("man_id       = 0x%x\n", hwconfig.man_id);
	(void) printf("model_code   = 0x%x\n", hwconfig.model_code);
	(void) printf("hw_rev       = %d\n", hwconfig.hw_rev);
	(void) printf("bootrom_rev  = %d\n", hwconfig.bootrom_rev);
	(void) printf("fw_rev       = %ld\n", hwconfig.fw_rev);
	(void) printf("sca_id[0]    = %d\n", hwconfig.sca_id[0]);
	(void) printf("sca_id[1]    = %d\n", hwconfig.sca_id[1]);
	(void) printf("sca_id[2]    = %d\n", hwconfig.sca_id[2]);
	(void) printf("sca_id[3]    = %d\n", hwconfig.sca_id[3]);
	(void) printf("sca_id[4]    = %d\n", hwconfig.sca_id[4]);
	(void) printf("sca_rev[0]   = %d\n", hwconfig.sca_rev[0]);
	(void) printf("sca_rev[1]   = %d\n", hwconfig.sca_rev[1]);
	(void) printf("sca_rev[2]   = %d\n", hwconfig.sca_rev[2]);
	(void) printf("sca_rev[3]   = %d\n", hwconfig.sca_rev[3]);
	(void) printf("sca_rev[4]   = %d\n", hwconfig.sca_rev[4]);
	(void) printf("bob_id[0]    = %d\n", hwconfig.bob_id[0]);
	(void) printf("bob_id[1]    = %d\n", hwconfig.bob_id[1]);
	(void) printf("bob_id[2]    = %d\n", hwconfig.bob_id[2]);
	(void) printf("bob_id[3]    = %d\n", hwconfig.bob_id[3]);
	(void) printf("bob_id[4]    = %d\n", hwconfig.bob_id[4]);
	(void) printf("total_chans  = %d\n", hwconfig.total_chans);
	(void) printf("input_chans  = %d\n", hwconfig.input_chans);
	(void) printf("source_chans = %d\n", hwconfig.source_chans);
	(void) printf("tach_chans   = %d\n", hwconfig.tach_chans);
	(void) printf("lbus_present = %d\n", hwconfig.lbus_present);
	(void) printf("dram_size    = 0x%lx\n", hwconfig.dram_size);
	(void) printf("a24_used     = 0x%lx\n", hwconfig.a24_used);
	(void) printf("serial       = %s\n", hwconfig.serial);
    }
#endif

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    nchan = 2;
    chan_list[0] = E1432_INPUT_CHAN(1);
    chan_list[1] = E1432_INPUT_CHAN(2);
    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    group));
	return -1;
    }

    {
	SHORTSIZ16 lines;

	/*CHECK(e1432_set_ttltrg_satrg(hw, chan_list[0], E1432_TTLTRG_2));*/
	CHECK(e1432_get_ttltrg_satrg(hw, chan_list[0], &lines));
	(void) printf("satrg = %d\n", lines);
	/*CHECK(e1432_set_ttltrg_clock(hw, chan_list[0], E1432_TTLTRG_3));*/
	CHECK(e1432_get_ttltrg_clock(hw, chan_list[0], &lines));
	(void) printf("clock = %d\n", lines);
	CHECK(e1432_get_ttltrg_lines(hw, chan_list[0], &lines));
	(void) printf("lines = %d\n", lines);
    }

    CHECK(e1432_init_measure_to_booted(hw, group, 1));
    CHECK(e1432_init_measure_finish(hw, group, 1));

    {
	SHORTSIZ16 lines;

	/*CHECK(e1432_set_ttltrg_satrg(hw, chan_list[0], E1432_TTLTRG_2));*/
	CHECK(e1432_get_ttltrg_satrg(hw, chan_list[0], &lines));
	(void) printf("satrg = %d\n", lines);
	/*CHECK(e1432_set_ttltrg_clock(hw, chan_list[0], E1432_TTLTRG_3));*/
	CHECK(e1432_get_ttltrg_clock(hw, chan_list[0], &lines));
	(void) printf("clock = %d\n", lines);
	CHECK(e1432_get_ttltrg_lines(hw, chan_list[0], &lines));
	(void) printf("lines = %d\n", lines);
    }

    return 0;
}
